function [sys,E]=Epot(M,xt,Ep,m,E)
%   EPOT permet de fabriquer le systme {objet physique - nergie
%   potentielle}
%   [sys,E]=Epot(M,xt,Ep,m,E)
%               >> M = nom des diffrentes marches
%               >> xt = positions de chaque marche
%               >> Ep = valeur des nergies potentielles 
%               >> m = masse de l'objet physique (rapporte  l'lectron)
%               >> E = valeurs de l'nergie de l'objet physique
%               << sys = systme {objet physique - nergie). Il y a autant
%               de systmes que de valeurs de E.
%               << E = valeurs de E renvoyes (on exclut en effet les
%               valeurs telles que E=Ep pour viter le cas singulier k=0. 
%
%   Olivier Pujol : septembre 2013
%
%% Vrifications

if (m<=0),error('La masse doit tre positive !');end
if (length(Ep)~=length(xt)+1),error('Le nombre de valeurs de Ep est incorrect !');end

% On vrifie qu'aucune valeur de E n'est gale  une valeur de Ep
for i=1:length(Ep)
    Ind=(abs(E-Ep(i))<eps); % Recherche des valeurs de E pour lesquelles E=Ep
    E=E(Ind~=1);            % On ne garde pas les valeurs de E correspondantes
end
clear i Ind

%% Initialisations

sys=cell(size(E));
k=cell(size(E));
step=cell(size(xt));

%% Construction du systme {nergie potentielle-objet physique}

for n=1:length(E)
    k{n}=VectOnde(E(n),m,Ep);

    for p=1:length(xt)
        step{p}=marche(M{p},xt(p),Ep(p),Ep(p+1),k{n}(p),k{n}(p+1));
    end
    sys{n}=Systeme(step{1:end});
end

return;